<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    if (!empty($_POST['files'])) {
        foreach ($_POST['files'] as $file) {
            $filePath = __DIR__ . '/../' . basename($file);
            if (file_exists($filePath)) {
                unlink($filePath);
            }
        }
    }
}

$files = array_diff(scandir(__DIR__ . '/../'), ['.', '..']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
    <h2>File Manager</h2>
    <form method="post">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Select</th>
                    <th>File Name</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($files as $file): ?>
                    <tr>
                        <td><input type="checkbox" name="files[]" value="<?= htmlspecialchars($file) ?>"></td>
                        <td><?= htmlspecialchars($file) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <button type="submit" name="delete" class="btn btn-danger">Delete Selected</button>
    </form>
</body>
</html>
