<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

// Get the selected status filter (if any)
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';

// Pagination setup
$records_per_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;

// Determine the total number of customers (with or without status filter)
$total_stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE status LIKE :status");
$total_stmt->execute([':status' => "%$status_filter%"]);
$total_customers = $total_stmt->fetchColumn();
$total_pages = ceil($total_customers / $records_per_page);

// Modify the query to include status filter and order by created_at
$stmt = $pdo->prepare("SELECT id, profile_link, customer_name,date, created_at, make_model, contact_no, registration_no, mileage, status FROM users WHERE status LIKE :status ORDER BY created_at DESC LIMIT :offset, :records_per_page");
$stmt->bindValue(':status', "%$status_filter%", PDO::PARAM_STR);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':records_per_page', $records_per_page, PDO::PARAM_INT);
$stmt->execute();
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
</head>
<body>
    <!--<div id="global-loader">-->
    <!--    <div class="whirly-loader"></div>-->
    <!--</div>-->

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Customer List</h4>
                        <h6>Here is a list of all customers</h6>
                    </div>
                </div>

                <div class="row" style="margin-bottom: 100px;">
                    <div class="col-xl-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header">
                                <h5 class="card-title">Customer List</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-left">Customer Name</th>
                                            <th class="text-left">Date</th>
                                            <th class="text-left">Make & Model</th>
                                            <th class="text-left">Contact No</th>
                                            <th class="text-left">Registration No</th>
                                            <!--<th class="text-left">Mileage</th>-->
                                            <th class="text-left">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($customers as $customer): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($customer['customer_name']) ?></td>
                                            <td><?= date("m/d/Y", strtotime($customer['date'])) ?></td>
                                            <td><?= htmlspecialchars($customer['make_model']) ?></td>
                                            <td><?= htmlspecialchars($customer['contact_no']) ?></td>
                                            <td><?= htmlspecialchars($customer['registration_no']) ?></td>
                                            <!--<td><?= htmlspecialchars($customer['mileage']) ?></td>-->
                                            <td class="d-flex flex-wrap">
                                                <a href="edit_customer.php?id=<?= $customer['id'] ?>" class="btn btn-info btn-sm ms-2 text-nowrap">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <a href="profile.php?link=<?= $customer['profile_link'] ?>" class="btn btn-primary btn-sm ms-2 text-nowrap">
                                                    <i class="fas fa-eye"></i> View
                                                </a>
                                                <a href="add_updates.php?id=<?= $customer['id'] ?>" class="btn btn-primary btn-sm ms-2 text-nowrap" style="background-color: #092C4C !important; border: 1px solid #092C4C !important;">
                                                    <i class="fas fa-plus"></i> Add Updates
                                                </a>
                                                 <a href="job_info.php?id=<?= $customer['id'] ?>" class="btn btn-primary btn-sm ms-2 text-nowrap" target="_blank">
                                                          <i class="fas fa-briefcase"></i> Job Info
                                                </a>
                                                 <a href="final_look.php?id=<?= $customer['id'] ?>" class="btn btn-primary btn-sm ms-2 text-nowrap" target="_blank" style="background-color: green !important; border: 1px solid green !important;">
                                                   <i class='fas fa-check-circle'></i> Final Look
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                                
                                <!-- Pagination -->
                                <nav aria-label="Page navigation" class="m-2 pb-3">
                                    <ul class="pagination justify-content-center mb-3">
                                        <li class="page-item <?php echo ($current_page <= 1) ? 'disabled' : ''; ?>">
                                            <a class="page-link" href="<?php echo ($current_page > 1) ? '?page=' . ($current_page - 1) : 'javascript:void(0);'; ?>">Previous</a>
                                        </li>

                                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                            <li class="page-item <?php echo ($i == $current_page) ? 'active' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                            </li>
                                        <?php endfor; ?>

                                        <li class="page-item <?php echo ($current_page >= $total_pages) ? 'disabled' : ''; ?>">
                                            <a class="page-link" href="<?php echo ($current_page < $total_pages) ? '?page=' . ($current_page + 1) : 'javascript:void(0);'; ?>">Next</a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <?php include('partials/footer.php'); ?>

</body>
</html>
