<?php
session_start();
include_once 'config/db.php'; // Database connection

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $vehicle_features = [];
    $image_fields = ['front_image', 'back_image', 'left_image', 'right_image', 'top_image', 'bottom_image'];
    $image_paths = [];
    $upload_dir = "uploads/";

    // Process features checkboxes and dropdowns
    $fields = [
        'battery', 'horn', 'washer_nipples', 'wiper_blades', 'head_lights',
        'parking_lights', 'signal_lights', 'reverse_lights', 'fog_lamp', 'fender_light',
        'hood_light', 'stop_light', 'inside_mirror', 'power_mirror', 'retractable_mirror',
        'radio', 'dvd_screen', 'speakers', 'ash_tray', 'inner_door_locks',
        'fuse_box_cover', 'sun_visor', 'remote_key', 'smart_key', 'cigar_lighter',
        'velvet_carpets', 'mats', 'model_make_badges', 'fuel_tank_cap', 'alloy_wheels',
        'rim_cup', 'wheel_center_cup', 'mud_flaps', 'body_moldings', 'dicky_board',
        'hydraulic_jack', 'mechanical_jack', 'wheel_handles', 'spare_wheels',
        'reverse_sensors', 'antenna', 'dashboard_warning_lights'
    ];

    foreach ($fields as $field) {
        $vehicle_features[$field] = isset($_POST[$field]) ? $_POST[$field] : "No";
    }

    // Fuel Level and Remarks
    $fuel_level = $_POST['fuel_level'] ?? '';
    $remarks = $_POST['remarks'] ?? '';
    $damages_noted = $_POST['damages_noted'] ?? '';
    $customer_signature = $_POST['customer_signature'] ?? '';

    // Store Vehicle Diagram Markers (JSON Format)
    $vehicle_diagram = $_POST['vehicle_diagram'] ?? '[]';

    // Handle Image Uploads
    foreach ($image_fields as $field) {
        if (isset($_FILES[$field]) && $_FILES[$field]['error'] == 0) {
            $image_name = time() . "_" . basename($_FILES[$field]['name']);
            $target_file = $upload_dir . $image_name;

            if (move_uploaded_file($_FILES[$field]['tmp_name'], $target_file)) {
                $image_paths[$field] = $target_file;
            } else {
                $image_paths[$field] = "";
            }
        } else {
            $image_paths[$field] = "";
        }
    }

    // Convert array to JSON for storing in DB
    $vehicle_features_json = json_encode($vehicle_features);
    $image_paths_json = json_encode($image_paths);

    // Insert into Database
    $stmt = $conn->prepare("INSERT INTO vehicle_inspections (vehicle_features, fuel_level, remarks, damages_noted, vehicle_diagram, customer_signature, images) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssss", $vehicle_features_json, $fuel_level, $remarks, $damages_noted, $vehicle_diagram, $customer_signature, $image_paths_json);

    if ($stmt->execute()) {
        $_SESSION['success'] = "Form submitted successfully!";
    } else {
        $_SESSION['error'] = "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();

    // Redirect back to form
    header("Location: form_page.php");
    exit();
} else {
    header("Location: form_page.php");
    exit();
}
?>
