<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

// Fetch data with search and date filter
$search = isset($_GET['search']) ? $_GET['search'] : '';
$from_date = isset($_GET['from_date']) ? $_GET['from_date'] : '';
$to_date = isset($_GET['to_date']) ? $_GET['to_date'] : '';

$query = "SELECT final_look.*, users.customer_name 
          FROM final_look 
          JOIN users ON final_look.user_id = users.id 
          WHERE 1";

$params = [];

if (!empty($search)) {
    $query .= " AND users.customer_name LIKE ?";
    $params[] = "%$search%";
}

if (!empty($from_date) && !empty($to_date)) {
    $query .= " AND final_look.date BETWEEN ? AND ?";
    $params[] = $from_date;
    $params[] = $to_date;
}

$query .= " ORDER BY final_look.date DESC";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$completedWorks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
    <style>
        .table th, .table td { vertical-align: middle; }
        .search-container { display: flex; gap: 10px; margin-bottom: 15px; }
  @media (max-width: 768px) { 

            .image-container img { display: none; } /* Hide extra images */
            .image-container img:first-child { display: block; } /* Show only the first image */
        }
    </style>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Completed Works</h4>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <!-- Search & Date Filter -->
                        <!--<form method="GET" class="search-container">-->
                        <!--    <input type="text" name="search" class="form-control" placeholder="Search by Customer Name" value="<?= htmlspecialchars($search) ?>">-->
                        <!--    <input type="date" name="from_date" class="form-control" value="<?= htmlspecialchars($from_date) ?>">-->
                        <!--    <input type="date" name="to_date" class="form-control" value="<?= htmlspecialchars($to_date) ?>">-->
                        <!--    <button type="submit" class="btn btn-primary">Filter</button>-->
                        <!--    <a href="completed_works.php" class="btn btn-secondary">Clear</a>-->
                        <!--</form>-->

                        <!-- Completed Works Table -->
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Customer Name</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (count($completedWorks) > 0): ?>
                                    <?php foreach ($completedWorks as $work): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($work['id']) ?></td>
                                            <td><?= htmlspecialchars($work['customer_name']) ?></td>
                                    <td><?php echo htmlspecialchars(strlen($work['description']) > 30 ? substr($work['description'], 0, 30) . '...' : $work['description']); ?></td>
<td>
    <?php 
    if (!empty($work['image'])) {
        $images = json_decode($work['image']);
        if (is_array($images)) {
            // Always show the first image
            echo '<img src="' . htmlspecialchars(trim($images[0])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image">';
            
            // Show the next two images only on larger screens
            if (count($images) > 1) {
                echo '<img src="' . htmlspecialchars(trim($images[1])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
            }
            if (count($images) > 2) {
                echo '<img src="' . htmlspecialchars(trim($images[2])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
            }
        } else {
            echo 'No Image';  // If images are not in a valid array
        }
    } else {
        echo 'No Image';  // If there are no images at all
    }
    ?>
</td>



                                            <td><?= htmlspecialchars(date("d-m-Y", strtotime($work['date']))) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No records found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<style>
    /* Hide additional images on mobile devices */
    @media (max-width: 767px) {
        .hidden-mobile {
            display: none;
        }
    }

    /* Show all images on larger screens */
    @media (min-width: 768px) {
        .hidden-mobile {
            display: inline-block;
        }
    }
</style>

    <?php include('partials/footer.php'); ?>
</body>
</html>
