<?php
   session_start();
   include_once 'config/db.php';

   if (!isset($_SESSION['admin_logged_in'])) {
       header('Location: admin_login.php');
       exit;
   }

   if (isset($_GET['logout'])) {
       session_destroy();
       header('Location: admin_login.php');
       exit;
   }

   if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['customer_name'])) {
       $customer_name = $_POST['customer_name'];
       $address = $_POST['address'];
       $date = $_POST['date'];
       $make_model = $_POST['make_model'];
       $contact_no = $_POST['contact_no'];
       $registration_no = $_POST['registration_no'];
       $mileage = $_POST['mileage'];

       $profile_link = 'profile_' . uniqid();

       $stmt = $pdo->prepare("INSERT INTO users (customer_name, address, date, make_model, contact_no, registration_no, mileage, profile_link) VALUES (:customer_name, :address, :date, :make_model, :contact_no, :registration_no, :mileage, :profile_link)");
       $stmt->execute([
           ':customer_name' => $customer_name,
           ':address' => $address,
           ':date' => $date,
           ':make_model' => $make_model,
           ':contact_no' => $contact_no,
           ':registration_no' => $registration_no,
           ':mileage' => $mileage,
           ':profile_link' => $profile_link
       ]);

       $_SESSION['profile_link'] = $profile_link;

       header('Location: second_form.php');
       exit;
   }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Create Customer Profile</h4>
                        <h6>Fill in the customer details below</h6>
                    </div>
                    <ul class="table-top-head">
                    </ul>
                </div>

                <div class="row">
                    <div class="col-xl-6 d-flex" style="margin-bottom: 200px;">
                        <div class="card flex-fill">
                            <div class="card-header">
                                <h5 class="card-title">Basic Form</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="" class="add-product-form">
                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Customer Name</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="customer_name" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Address</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="address" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Date</label>
                                        <div class="col-lg-9">
                                            <input type="date" name="date" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Make/Model</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="make_model" class="form-control" required>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Contact Number</label>
                                        <div class="col-lg-9">
                                            <input 
                                                type="text" 
                                                name="contact_no" 
                                                class="form-control" 
                                                required
                                                pattern="^\+94\d{9}$" 
                                                title="Please enter a valid number starting with +94 and followed by 9 digits without spaces or special characters."
                                                oninput="validatePhoneNumber(this)"
                                                maxlength="12"
                                            >
                                            <small class="text-danger">Please do not include 0, spaces, or special characters. The number should start with +94 and be followed by 9 digits.</small>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Registration Number</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="registration_no" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Mileage</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="mileage" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-lg-12 text-center">
                                            <button type="submit" class="btn btn-primary w-100">Create Profile</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                     <div class="mb-4 mb-md-5 text-white d-block d-md-none"></div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php include('partials/footer.php'); ?>
<script>
    function validatePhoneNumber(input) {
        input.value = input.value.replace(/[^0-9+]/g, '');
        if (!input.value.startsWith('+94') && input.value !== '') {
            input.value = '+94' + input.value.replace(/[^0-9]/g, '');
        }
    }
</script>
</body>
</html>
