<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
    <style>
        @media only screen and (max-width: 600px) {
            td.col-6.col-md-4 {
                min-width: 10px;
                max-width: 200px;
            }
            label.col-form-label {
                display: block;
                width: 110%;
                overflow-wrap: break-word;
                white-space: normal;
            }
            td.col-6.col-md-3 {
                width: 200px !important;
                max-width: 200px !important;
                min-width: 100px;
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const imageFields = ['front_image', 'back_image', 'left_image', 'right_image', 'top_image', 'bottom_image'];
            imageFields.forEach(field => {
                const input = document.getElementById(field);
                const previewContainer = document.getElementById(`${field}_preview`);
                if (input && previewContainer) {
                    input.addEventListener('change', function(event) {
                        const file = event.target.files[0];
                        if (file) {
                            const reader = new FileReader();
                            reader.onload = function(e) {
                                const img = document.createElement('img');
                                img.src = e.target.result;
                                img.style.maxWidth = '200px';
                                img.style.maxHeight = '200px';
                                img.style.margin = '10px';
                                previewContainer.innerHTML = '';
                                previewContainer.appendChild(img);
                            };
                            reader.readAsDataURL(file);
                        }
                    });
                }
            });
        });
    </script>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>
    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>
        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Second Form</h4>
                        <h6>Fill in the Second Form details below</h6>
                    </div>
                </div>
                <div class="row mb-5" style="margin-bottom: 100px;">
                    <div class="col-xl-8 d-flex">
                        <div class="card flex-fill">
                            <div class="card-body">
                                <form method="POST" action="" enctype="multipart/form-data" class="form-horizontal">
                                    <div class="form-section">
                                        <h5 class="mb-3">Vehicle Features</h5>
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <tbody>
                                                    <?php
                                                    $fields = [
                                                        'battery', 'horn', 'washer_nipples', 'wiper_blades', 'head_lights',
                                                        'parking_lights', 'signal_lights', 'reverse_lights', 'fog_lamp', 'fender_light', 'hood_light', 'stop_light',
                                                        'inside_mirror', 'power_mirror', 'retractable_mirror', 'radio', 'dvd_screen', 'speakers', 'ash_tray',
                                                        'inner_door_locks', 'fuse_box_cover', 'sun_visor', 'remote_key', 'smart_key', 'cigar_lighter', 'velvet_carpets',
                                                        'mats', 'model_make_badges', 'fuel_tank_cap', 'alloy_wheels', 'rim_cup', 'wheel_center_cup', 'mud_flaps',
                                                        'body_moldings', 'dicky_board', 'hydraulic_jack', 'mechanical_jack', 'wheel_handles', 'spare_wheels',
                                                        'reverse_sensors', 'antenna', 'dashboard_warning_lights'
                                                    ];

                                                    for ($i = 0; $i < count($fields); $i += 2) {
                                                        $field1 = $fields[$i];
                                                        $label1 = ucwords(str_replace('_', ' ', $field1));
                                                        $field_name1 = strtolower(str_replace([' ', '–', '&'], ['_', '', ''], $field1));

                                                        $field2 = isset($fields[$i + 1]) ? $fields[$i + 1] : null;
                                                        $label2 = $field2 ? ucwords(str_replace('_', ' ', $field2)) : '';
                                                        $field_name2 = $field2 ? strtolower(str_replace([' ', '–', '&'], ['_', '', ''], $field2)) : '';

                                                        echo "<tr>";
                                                        echo "<td class='col-6 col-md-3'>$label1</td>";
                                                        echo "<td class='col-6 col-md-3'><select name='$field_name1' id='$field_name1' class='form-control'>";
                                                        echo "<option value='Yes'>Yes</option>";
                                                        echo "<option value='No'>No</option>";
                                                        echo "</select></td>";

                                                        if ($field2) {
                                                            echo "<td class='col-6 col-md-3'>$label2</td>";
                                                            echo "<td class='col-6 col-md-3'><select name='$field_name2' id='$field_name2' class='form-control'>";
                                                            echo "<option value='Yes'>Yes</option>";
                                                            echo "<option value='No'>No</option>";
                                                            echo "</select></td>";
                                                        } else {
                                                            echo "<td colspan='2'></td>";
                                                        }
                                                        echo "</tr>";
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="form-section mt-4">
                                        <h5 class="mb-3">Fuel Level</h5>
                                        <div class="form-group">
                                            <label for="fuel_level" class="col-form-label">Fuel Level:</label>
                                            <select name="fuel_level" id="fuel_level" class="form-control">
                                                <option value="Empty">Empty</option>
                                                <option value="4/1">4/1</option>
                                                <option value="4/2">4/2</option>
                                                <option value="4/3">4/3</option>
                                                <option value="Full">Full</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-section mt-4">
                                        <h5 class="mb-3">Remarks</h5>
                                        <div class="form-group">
                                            <label for="remarks" class="col-form-label">Remarks:</label>
                                            <textarea name="remarks" id="remarks" class="form-control" rows="4" placeholder="Enter any remarks here..."></textarea>
                                        </div>
                                    </div>
                                    <div class="form-section mt-4">
                                        <h5 class="mb-3">Damages Noted</h5>
                                        <div class="form-group">
                                            <label for="damages_noted" class="col-form-label">Damages Noted:</label>
                                            <textarea name="damages_noted" id="damages_noted" class="form-control" rows="4" placeholder="Enter any damages here..."></textarea>
                                        </div>
                                    </div>
                                    <div class="form-section mt-4">
                                        <h5 class="mb-3">Customer Signature</h5>
                                        <div class="border border-secondary rounded p-3">
                                            <canvas id="customer_signatureCanvas" class="w-100 border border-dark" style="height: 200px; cursor: crosshair;"></canvas>
                                            <button type="button" id="clearCustomerBtn" class="btn btn-danger mt-2">Clear Signature</button>
                                            <button type="button" id="saveCustomerBtn" class="btn btn-primary mt-2">Save Signature</button>
                                        </div>
                                        <input type="hidden" id="customer_signatureData" name="customer_signature">
                                    </div>
                                    <div class="form-section">
                                        <h5 class="mb-3">Markers</h5>
                                        <div class="col-md-8">
                                            <h5>Click on the image to add markers</h5>
                                            <div class="position-relative">
                                                <img src="https://img.freepik.com/premium-vector/car-line-draw-insurance-rent-damage-condition-report-form_510486-111.jpg" id="mapImage" class="border img-fluid" style="background-color: #e0e0e0;"/>
                                                <svg id="svgOverlay" class="position-absolute top-0 start-0" style="width: 100%; height: 100%; pointer-events: none;"></svg>
                                            </div>
                                        </div>
                                        <ul id="markerList" class="list-group"></ul>
                                    </div>
                                    <input type="hidden" id="vehicle_diagram" name="vehicle_diagram" value="">
                                    <div class="form-section mt-4">
                                        <h5 class="mb-3">Current Condition of the Vehicle</h5>
                                        <div class="row">
                                            <?php
                                            $image_fields = ['front_image', 'back_image', 'left_image', 'right_image', 'top_image', 'bottom_image'];
                                            foreach ($image_fields as $image_field) {
                                                echo "<div class='col-md-6 mb-3'>";
                                                echo "<label for='$image_field' class='col-form-label fw-bold'>" . ucfirst(str_replace('_', ' ', $image_field)) . ":</label>";
                                                echo "<input type='file' name='$image_field' id='$image_field' class='form-control' accept='image/*'>";
                                                echo "<div id='{$image_field}_preview' class='mt-2'></div>";
                                                echo "</div>";
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-lg-12 text-center">
                                            <button type="submit" class="btn btn-primary w-100">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mb-4 mb-md-5 text-white d-block d-md-none"></div>
            </div>
        </div>
    </div>
    <?php include('partials/footer.php'); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/script/custom.js"></script>
</body>
</html>
