<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$user_id = isset($_GET['id']) ? (int)$_GET['id'] : null;
if ($user_id === null) {
    header('Location: customer-list.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $images = [];
    
    if (isset($_FILES['images']) && !empty($_FILES['images']['name'][0])) {
        $uploads_dir = 'uploads/';
        foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
            $image_name = basename($_FILES['images']['name'][$key]);
            $target_path = $uploads_dir . $image_name;
            move_uploaded_file($tmp_name, $target_path);
            $images[] = $target_path;
        }
    }
    
    $image_paths = implode(",", $images);
    
    $current_date = date('Y-m-d H:i:s');
    $stmt = $pdo->prepare("INSERT INTO updates (users_id, title, description, image, created_at, updated_at) 
                           VALUES (:users_id, :title, :description, :image, :created_at, :updated_at)");
    $stmt->bindParam(':users_id', $user_id);
    $stmt->bindParam(':title', $title);
    $stmt->bindParam(':description', $description);
    $stmt->bindParam(':image', $image_paths);
    $stmt->bindParam(':created_at', $current_date);
    $stmt->bindParam(':updated_at', $current_date);
    $stmt->execute();

    header("Location: customer-list.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
    <style>
        .image-preview {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }
        .preview-item {
            position: relative;
            width: 150px;
            height: 150px;
            border-radius: 10px;
            overflow: hidden;
            border: 2px solid #ddd;
            box-sizing: border-box;
        }
        .preview-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .remove-img {
            position: absolute;
            top: 5px;
            right: 5px;
            background: rgba(255, 0, 0, 0.5);
            color: white;
            border: none;
            border-radius: 50%;
            cursor: pointer;
            padding: 5px;
        }
    </style>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Add Update for Customer</h4>
                    </div>
                </div>

                <form action="add_updates.php?id=<?= $user_id ?>" method="POST" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="title">Title</label>
                                        <input type="text" id="title" name="title" class="form-control" required>
                                    </div>

                                    <div class="form-group mt-3">
                                        <label for="description">Description</label>
                                        <textarea id="description" name="description" class="form-control" rows="4" required></textarea>
                                    </div>

                                    <div class="form-group mt-3">
                                        <label for="images">Upload Images</label>
                                        <input type="file" id="images" name="images[]" class="form-control" multiple accept="image/*" onchange="previewImages()">
                                    </div>

                                    <div id="image-preview" class="image-preview mt-3">
                                    </div>

                                    <button type="submit" class="btn btn-primary mt-3">Add Update</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
      <div class="mb-4 mb-md-5 text-white d-block d-md-none"></div>
    </div>

    <?php include('partials/footer.php'); ?>

    <script>
        function previewImages() {
            const previewContainer = document.getElementById('image-preview');
            previewContainer.innerHTML = '';

            const files = document.getElementById('images').files;
            for (const file of files) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    const div = document.createElement('div');
                    div.classList.add('preview-item');
                    div.appendChild(img);

                    const removeButton = document.createElement('button');
                    removeButton.textContent = 'X';
                    removeButton.classList.add('remove-img');
                    removeButton.onclick = function() {
                        div.remove();
                    };
                    div.appendChild(removeButton);
                    
                    previewContainer.appendChild(div);
                };
                reader.readAsDataURL(file);
            }
        }
    </script>
</body>
</html>
