<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$records_per_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;

$total_stmt = $pdo->query("SELECT COUNT(*) FROM updates");
$total_updates = $total_stmt->fetchColumn();
$total_pages = ceil($total_updates / $records_per_page);

$stmt = $pdo->prepare("SELECT * FROM updates LIMIT :offset, :records_per_page");
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':records_per_page', $records_per_page, PDO::PARAM_INT);
$stmt->execute();
$updates = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- SweetAlert2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css" rel="stylesheet">
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Daily Updates</h4>
                        <h6>Manage customer updates here</h6>
                    </div>
                </div>

                <div class="row" style="margin-bottom: 100px;">
                    <div class="col-xl-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header">
                                <h5 class="card-title">Customer Updates</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-left">Title</th>
                                            <th class="text-left">Description</th>
                                            <th class="text-left">Date</th>
                                            <th class="text-left">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($updates as $update): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($update['title']) ?></td>
                                            <td><?= htmlspecialchars($update['description']) ?></td>
                                            <td><?= date("m/d/Y", strtotime($update['created_at'])) ?></td>
                                            <td class="d-flex flex-wrap">
                                                <a href="edit_update.php?id=<?= $update['id'] ?>" class="btn btn-info btn-sm ms-2 text-nowrap mb-2 mb-md-0">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <a href="javascript:void(0);" class="btn btn-danger btn-sm ms-2 text-nowrap delete-update mb-2 mb-md-0" data-id="<?= $update['id'] ?>">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>

                                <!-- Pagination -->
                                <nav aria-label="Page navigation" class="m-2 pb-3">
                                    <ul class="pagination justify-content-center mb-3">
                                        <li class="page-item <?= ($page <= 1) ? 'disabled' : ''; ?>">
                                            <a class="page-link" href="<?= ($page > 1) ? '?page=' . ($page - 1) : 'javascript:void(0);'; ?>">Previous</a>
                                        </li>

                                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                            <li class="page-item <?= ($i == $page) ? 'active' : ''; ?>">
                                                <a class="page-link" href="?page=<?= $i; ?>"><?= $i; ?></a>
                                            </li>
                                        <?php endfor; ?>

                                        <li class="page-item <?= ($page >= $total_pages) ? 'disabled' : ''; ?>">
                                            <a class="page-link" href="<?= ($page < $total_pages) ? '?page=' . ($page + 1) : 'javascript:void(0);'; ?>">Next</a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php include('partials/footer.php'); ?>

    <!-- Include Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Include SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.all.min.js"></script>
    
    <script>
        document.querySelectorAll('.delete-update').forEach(function(deleteBtn) {
            deleteBtn.addEventListener('click', function() {
                var updateId = this.getAttribute('data-id');
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'No, cancel!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = 'delete_update.php?id=' + updateId;
                    }
                });
            });
        });
    </script>
</body>
</html>
