<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

// Fetch data with search and date filter
$search = isset($_GET['search']) ? $_GET['search'] : '';
$from_date = isset($_GET['from_date']) ? $_GET['from_date'] : '';
$to_date = isset($_GET['to_date']) ? $_GET['to_date'] : '';

$query = "SELECT final_look.*, users.customer_name 
          FROM final_look 
          JOIN users ON final_look.user_id = users.id 
          WHERE 1";

$params = [];

if (!empty($search)) {
    $query .= " AND users.customer_name LIKE ?";
    $params[] = "%$search%";
}

if (!empty($from_date) && !empty($to_date)) {
    $query .= " AND final_look.date BETWEEN ? AND ?";
    $params[] = $from_date;
    $params[] = $to_date;
}

$query .= " ORDER BY final_look.date DESC";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$completedWorks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
    <style>
        .table th, .table td { vertical-align: middle; }
        .search-container { display: flex; gap: 10px; margin-bottom: 15px; }
        
        /* Hide additional images on mobile devices */
        @media (max-width: 767px) {
            .hidden-mobile { display: none; }
        }

        /* Show all images on larger screens */
        @media (min-width: 768px) {
            .hidden-mobile { display: inline-block; }
        }
    </style>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Completed Works</h4>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <!-- Completed Works Table -->
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Customer Name</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Date</th>
                                    <th>Action</th> <!-- Action Column -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (count($completedWorks) > 0): ?>
                                    <?php foreach ($completedWorks as $work): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($work['id']) ?></td>
                                            <td><?= htmlspecialchars($work['customer_name']) ?></td>
                                            <td><?= htmlspecialchars(strlen($work['description']) > 30 ? substr($work['description'], 0, 30) . '...' : $work['description']); ?></td>
                                            <td>
                                                <?php 
                                                if (!empty($work['image'])) {
                                                    $images = json_decode($work['image']);
                                                    if (is_array($images)) {
                                                        // Always show the first image
                                                        echo '<img src="' . htmlspecialchars(trim($images[0])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image">';

                                                        // Show the next two images only on larger screens
                                                        if (count($images) > 1) {
                                                            echo '<img src="' . htmlspecialchars(trim($images[1])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
                                                        }
                                                        if (count($images) > 2) {
                                                            echo '<img src="' . htmlspecialchars(trim($images[2])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
                                                        }
                                                    } else {
                                                        echo 'No Image';  // If images are not in a valid array
                                                    }
                                                } else {
                                                    echo 'No Image';  // If there are no images at all
                                                }
                                                ?>
                                            </td>
                                            <td><?= htmlspecialchars(date("d-m-Y", strtotime($work['date']))) ?></td>
                                            <td>
                                                <?php if (!empty($work['video_url'])): ?>
                                                    <button class="btn btn-primary btn-sm" onclick="openVideoModal('<?= htmlspecialchars($work['video_url']) ?>')">
                                                        <i class="fa fa-play-circle"></i> View Video
                                                    </button>
                                                    <a href="<?= htmlspecialchars($work['video_url']) ?>" download class="btn btn-success btn-sm">
                                                        <i class="fa fa-download"></i> Download Video
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted">No Video</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No records found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Video Modal -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="videoModalLabel">Video Preview</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <video id="videoPlayer" controls width="100%">
                        <source src="" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
            </div>
        </div>
    </div>

    <?php include('partials/footer.php'); ?>

    <script>
        function openVideoModal(videoUrl) {
            let videoPlayer = document.getElementById("videoPlayer");
            videoPlayer.src = videoUrl; // Set video URL
            var videoModal = new bootstrap.Modal(document.getElementById('videoModal'));
            videoModal.show();
        }
    </script>
</body>
</html>
