<?php
// success.php

// Get the status and message from the URL
$status = isset($_GET['status']) ? $_GET['status'] : '';
$message = isset($_GET['message']) ? $_GET['message'] : '';
$sms_status = isset($_GET['sms_status']) ? $_GET['sms_status'] : '';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Success Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet"> <!-- FontAwesome for icons -->
</head>
<body>

<div class="container mt-5">
    <?php if ($status == 'success') { ?>
        <div class="alert alert-solid-secondary border border-secondary mb-3 p-3">
            <div class="d-flex align-items-start">
                <div class="me-2">
                    <i class="fas fa-check-circle text-success" style="font-size: 24px;"></i>
                </div>
                <div class="w-100">
                    <div class="fw-semibold d-flex justify-content-between">
                        <span>Success</span>
                        <button type="button" class="btn-close p-0" data-bs-dismiss="alert" aria-label="Close"><i class="fas fa-times"></i></button>
                    </div>
                    <div class="fs-6 mb-1"><?php echo htmlspecialchars($message); ?></div>
                    <?php if ($sms_status) { ?>
                        <div class="fs-6">SMS Status: <?php echo htmlspecialchars($sms_status); ?></div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } elseif ($status == 'error') { ?>
        <div class="alert alert-danger border border-danger mb-3 p-3">
            <div class="d-flex align-items-start">
                <div class="me-2">
                    <i class="fas fa-times-circle text-danger" style="font-size: 24px;"></i>
                </div>
                <div class="w-100">
                    <div class="fw-semibold d-flex justify-content-between">
                        <span>Error</span>
                        <button type="button" class="btn-close p-0" data-bs-dismiss="alert" aria-label="Close"><i class="fas fa-times"></i></button>
                    </div>
                    <div class="fs-6 mb-1"><?php echo htmlspecialchars($message); ?></div>
                </div>
            </div>
        </div>
    <?php } ?>

    <!-- Back to Admin Button -->
    <div class="mt-4">
        <a href="admin_dashboard.php" class="btn btn-primary">
            <i class="fas fa-arrow-left me-2"></i>Back to Admin
        </a>
    </div>
</div>

<!-- Include Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
