<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$records_per_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;

$total_stmt = $pdo->query("SELECT COUNT(*) FROM jobs");
$total_jobs = $total_stmt->fetchColumn();
$totalPages = ceil($total_jobs / $records_per_page);

$stmt = $pdo->prepare("
    SELECT jobs.id, jobs.user_id, jobs.title, jobs.description, jobs.images, jobs.video_upload, users.customer_name
    FROM jobs
    LEFT JOIN users ON jobs.user_id = users.id
    ORDER BY jobs.id DESC 
    LIMIT :offset, :records_per_page
");

$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':records_per_page', $records_per_page, PDO::PARAM_INT);
$stmt->execute();

$jobs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Vehicle Work List</h4>
                    </div>
                </div>
                <div class="row" style="margin-bottom: 100px;">
                    <div class="col-xl-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th class="text-left">ID</th>
                                <th class="text-left">Customer Name</th>
                                <th class="text-left">Title</th>
                                <th class="text-left">Description</th>
                                <th class="text-left">Images</th>
                                <th class="text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($jobs as $row) { ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                                    <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                                    <td><?php echo htmlspecialchars(strlen($row['title']) > 20 ? substr($row['title'], 0, 20) . '...' : $row['title']); ?></td>
                                    <td><?php echo htmlspecialchars(strlen($row['description']) > 30 ? substr($row['description'], 0, 30) . '...' : $row['description']); ?></td>

<td>
    <?php 
    if ($row['images']) {
        $images = json_decode($row['images']);
        if (is_array($images)) {
            // Always show the first image
            echo '<img src="' . htmlspecialchars(trim($images[0])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image">';

            // Show the next two images only on larger screens
            if (count($images) > 1) {
                echo '<img src="' . htmlspecialchars(trim($images[1])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
            }
            if (count($images) > 2) {
                echo '<img src="' . htmlspecialchars(trim($images[2])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
            }
        }
    }
    ?>
</td>
                                    <td class="d-flex">
                                        <a href="edit_work_list.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm ms-2">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>

                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <!--<div class="pagination">-->
                <!--    <ul class="pagination justify-content-center">-->
                <!--        <li class="page-item <?php if ($page == 1) echo 'disabled'; ?>">-->
                <!--            <a class="page-link" href="?page=<?php echo $page - 1; ?>" aria-label="Previous">-->
                <!--                <span aria-hidden="true">&laquo;</span>-->
                <!--            </a>-->
                <!--        </li>-->
                <!--        <?php for ($i = 1; $i <= $totalPages; $i++) { ?>-->
                <!--            <li class="page-item <?php if ($i == $page) echo 'active'; ?>">-->
                <!--                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>-->
                <!--            </li>-->
                <!--        <?php } ?>-->
                <!--        <li class="page-item <?php if ($page == $totalPages) echo 'disabled'; ?>">-->
                <!--            <a class="page-link" href="?page=<?php echo $page + 1; ?>" aria-label="Next">-->
                <!--                <span aria-hidden="true">&raquo;</span>-->
                <!--            </a>-->
                <!--        </li>-->
                <!--    </ul>-->
                <!--</div>-->

            </div>
        </div>
    </div>
            </div>
        </div>
    </div>
    <?php include('partials/footer.php'); ?>
<style>
    /* Hide additional images on mobile devices */
    @media (max-width: 767px) {
        .hidden-mobile {
            display: none;
        }
    }

    /* Show all images on larger screens */
    @media (min-width: 768px) {
        .hidden-mobile {
            display: inline-block;
        }
    }
</style>
</body>
</html>
