function previewImage(input, previewId) {
    const previewDiv = document.getElementById(previewId);
    previewDiv.innerHTML = ''; // Clear previous preview

    if (input.files && input.files[0]) {
        const file = input.files[0];

        // Validate image type
        const validImageTypes = ['image/jpeg', 'image/png', 'image/gif'];
        if (!validImageTypes.includes(file.type)) {
            alert('Invalid file type. Please upload a JPG, PNG, or GIF image.');
            input.value = ''; // Reset input field
            return;
        }

        // Validate image size (2MB limit)
        if (file.size > 2 * 1024 * 1024) {
            alert('File size exceeds 2MB. Please upload a smaller image.');
            input.value = ''; // Reset input field
            return;
        }

        const reader = new FileReader();
        reader.onload = function (e) {
            const img = document.createElement('img');
            img.src = e.target.result;
            img.classList.add('img-thumbnail');
            img.style.maxWidth = '200px';
            img.style.maxHeight = '200px';

            previewDiv.appendChild(img);
        };
        reader.readAsDataURL(file);
    }
}
