<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

// Check if 'id' is passed via GET
if (isset($_GET['id'])) {
    $customer_id = $_GET['id'];

    // Fetch customer details from the database
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->execute([':id' => $customer_id]);
    $customer = $stmt->fetch();

    // If no customer is found with the given ID, show an error
    if (!$customer) {
        echo "Customer not found!";
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['customer_name'])) {
    // Get updated data from the form
    $customer_name = $_POST['customer_name'];
    $address = $_POST['address'];
    $date = $_POST['date'];
    $make_model = $_POST['make_model'];
    $contact_no = $_POST['contact_no'];
    $registration_no = $_POST['registration_no'];
    $mileage = $_POST['mileage'];

    // Update customer data in the database
    $stmt = $pdo->prepare("UPDATE users SET customer_name = :customer_name, address = :address, date = :date, make_model = :make_model, contact_no = :contact_no, registration_no = :registration_no, mileage = :mileage WHERE id = :id");
    $stmt->execute([
        ':customer_name' => $customer_name,
        ':address' => $address,
        ':date' => $date,
        ':make_model' => $make_model,
        ':contact_no' => $contact_no,
        ':registration_no' => $registration_no,
        ':mileage' => $mileage,
        ':id' => $customer_id
    ]);

    // Set success message in session
    $_SESSION['success_message'] = 'Customer updated successfully!';
    $_SESSION['profile_link'] = $customer['profile_link'];  // Store profile link for next form
    
    // Redirect to the second form (edit_second_form.php) with the customer ID
    header('Location: edit_second_form.php?id=' . $customer_id);  // Pass customer ID in the URL
    exit;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>

</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Edit Customer Profile</h4>
                        <h6>Update the customer details below</h6>
                    </div>
                </div>

                <div class="row" style="margin-bottom: 100px;">
                    <div class="col-xl-6 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header">
                                <h5 class="card-title">Edit Customer Profile</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="">
                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Customer Name</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="customer_name" class="form-control" value="<?php echo htmlspecialchars($customer['customer_name']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Address</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="address" class="form-control" value="<?php echo htmlspecialchars($customer['address']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Date</label>
                                        <div class="col-lg-9">
                                            <input type="date" name="date" class="form-control" value="<?php echo htmlspecialchars($customer['date']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Make/Model</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="make_model" class="form-control" value="<?php echo htmlspecialchars($customer['make_model']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Contact Number</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="contact_no" class="form-control" value="<?php echo htmlspecialchars($customer['contact_no']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Registration Number</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="registration_no" class="form-control" value="<?php echo htmlspecialchars($customer['registration_no']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label class="col-lg-3 col-form-label">Mileage</label>
                                        <div class="col-lg-9">
                                            <input type="text" name="mileage" class="form-control" value="<?php echo htmlspecialchars($customer['mileage']); ?>" required>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-lg-12 text-center">
                                            <button type="submit" class="btn btn-primary w-100">Update Profile</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mb-4 mb-md-5 text-white d-block d-md-none">
                 </div>
            </div>
        </div>
    </div>

    <?php include('partials/footer.php'); ?>

</body>
</html>
