<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile Update Status</title>
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap.min.css">

	<!-- Datetimepicker CSS -->
	<link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

	<!-- animation CSS -->
	<link rel="stylesheet" href="assets/css/animate.css">

	<!-- Feathericon CSS -->
	<link rel="stylesheet" href="assets/css/feather.css">

	<!-- Select2 CSS -->
	<link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

	<!-- Bootstrap Tagsinput CSS -->
	<link rel="stylesheet" href="assets/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css">

	<!-- Datatable CSS -->
	<link rel="stylesheet" href="assets/css/dataTables.bootstrap5.min.css">

	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
	<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
</head>
<body>

<div class="container mt-5">
    <div class="card">
        <div class="card-header bg-info text-white">
            <h4 class="card-title">Profile Update Status</h4>
        </div>
        <div class="card-body">

            <?php
            if (isset($_GET['sms_status'])) {
                $sms_status = htmlspecialchars($_GET['sms_status']);
                $sms_message = htmlspecialchars($_GET['sms_message']);
                $profile_link = htmlspecialchars($_GET['profile_link']);
                
                // Display success or error alert based on sms_status
                if ($sms_status == 'success') {
                    echo "<div class='alert alert-success'>";
                    echo "<strong>Success!</strong> $sms_message";
                    echo "</div>";
                } else {
                    echo "<div class='alert alert-danger'>";
                    echo "<strong>Error!</strong> $sms_message";
                    echo "</div>";
                }

                // Profile link
                echo "<p><strong>Visit your profile here:</strong> <a href='https://blog.onedriveme.com/profile.php?link=$profile_link' class='btn btn-primary'>Profile Link</a></p>";

            } else {
                echo "<div class='alert alert-warning'>No status available.</div>";
            }
            ?>
            
            <!-- Back to Admin Button -->
            <a href="admin_dashboard.php" class="btn btn-primary mt-3">
                <i class="fas fa-arrow-left me-2"></i>Back to Admin
            </a>

        </div>
    </div>
</div>
<!-- jQuery -->
	<script src="assets/js/jquery-3.7.1.min.js"></script>

	<!-- Feather Icon JS -->
	<script src="assets/js/feather.min.js"></script>

	<!-- Slimscroll JS -->
	<script src="assets/js/jquery.slimscroll.min.js"></script>

	<!-- Datatable JS -->
	<script src="assets/js/jquery.dataTables.min.js"></script>
	<script src="assets/js/dataTables.bootstrap5.min.js"></script>

	<!-- Bootstrap Core JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>

	<!-- Select2 JS -->
	<script src="assets/plugins/select2/js/select2.min.js"></script>

	<!-- Datetimepicker JS -->
	<script src="assets/js/moment.min.js"></script>
	<script src="assets/js/bootstrap-datetimepicker.min.js"></script>

	<!-- Bootstrap Tagsinput JS -->
	<script src="assets/plugins/bootstrap-tagsinput/bootstrap-tagsinput.js"></script>

	<!-- Sweetalert 2 -->
	<script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
	<script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

	<!-- Custom JS -->
    
	<script src="assets/js/theme-script.js"></script>
	<script src="assets/js/script.js"></script>
</body>
</html>
