<?php
session_start();
include_once 'config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$records_per_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;

$total_stmt = $pdo->query("SELECT COUNT(*) FROM jobs");
$total_jobs = $total_stmt->fetchColumn();
$totalPages = ceil($total_jobs / $records_per_page);

$stmt = $pdo->prepare("
    SELECT jobs.id, jobs.user_id, jobs.title, jobs.description, jobs.images, jobs.video_upload, users.customer_name
    FROM jobs
    LEFT JOIN users ON jobs.user_id = users.id
    ORDER BY jobs.id DESC 
    LIMIT :offset, :records_per_page
");

$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':records_per_page', $records_per_page, PDO::PARAM_INT);
$stmt->execute();

$jobs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include('partials/head.php'); ?>
</head>
<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="main-wrapper">
        <?php include('partials/header.php'); ?>
        <?php include('partials/sidebar.php'); ?>

        <div class="page-wrapper" style="max-height: 100vh; overflow-y: auto;">
            <div class="content">
                <div class="page-header mb-3">
                    <div class="page-title">
                        <h4>Vehicle Work List</h4>
                    </div>
                </div>
                <div class="row" style="margin-bottom: 100px;">
                    <div class="col-xl-12 d-flex">
                        <div class="card flex-fill">
                            <div class="card-header">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th class="text-left">ID</th>
                                                <th class="text-left">Customer Name</th>
                                                <th class="text-left">Title</th>
                                                <th class="text-left">Description</th>
                                                <th class="text-left">Images</th>
                                                <th class="text-left">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($jobs as $row) { ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                                                    <td><?php echo htmlspecialchars(strlen($row['title']) > 20 ? substr($row['title'], 0, 20) . '...' : $row['title']); ?></td>
                                                    <td><?php echo htmlspecialchars(strlen($row['description']) > 30 ? substr($row['description'], 0, 30) . '...' : $row['description']); ?></td>

                                                    <td>
                                                        <?php 
                                                        if (!empty($row['images'])) {
                                                            $images = json_decode($row['images'], true);
                                                            if (is_array($images) && count($images) > 0) {
                                                                echo '<img src="' . htmlspecialchars(trim($images[0])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image">';
                                                                
                                                                if (count($images) > 1) {
                                                                    echo '<img src="' . htmlspecialchars(trim($images[1])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
                                                                }
                                                                if (count($images) > 2) {
                                                                    echo '<img src="' . htmlspecialchars(trim($images[2])) . '" alt="Job Image" width="80" height="80" style="border-radius: 5px; margin-right: 5px;" class="job-image hidden-mobile">';
                                                                }
                                                            }
                                                        }
                                                        ?>
                                                    </td>

                                                    <td class="d-flex">
<?php if (!empty($row['video_upload'])) { ?>
    <!-- View Video Button with custom color -->
    <button class="btn btn-primary btn-sm ms-2" onclick="openVideoModal('<?php echo htmlspecialchars($row['video_upload']); ?>')" style="background-color: #007bff !important; color: white; border: 1px solid #ffffff00 !important;">
        <i class="fas fa-play-circle"></i> View
    </button>

    <!-- Download Video Button with custom color -->
    <a href="<?php echo htmlspecialchars($row['video_upload']); ?>" download class="btn btn-primary btn-sm ms-2" style="background-color: #28a745 !important; color: white; border: 1px solid #ffffff00 !important;">
        <i class="fas fa-download"></i> Download
    </a>
<?php } ?>

<!-- Edit Button with custom color -->
<a href="edit_work_list.php?id=<?php echo $row['id']; ?>" class="btn btn-primary btn-sm ms-2" style="background-color: #ffc107 !important; color: white; border: 1px solid #ffffff00 !important;">
    <i class="fas fa-edit"></i> Edit
</a>

                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                    
                                </div>
                                
                            </div>
                                            <!-- Pagination -->
                <!--<div class="pagination">-->
                <!--    <ul class="pagination justify-content-center">-->
                <!--        <li class="page-item <?php if ($page == 1) echo 'disabled'; ?>">-->
                <!--            <a class="page-link" href="?page=<?php echo $page - 1; ?>" aria-label="Previous">-->
                <!--                <span aria-hidden="true">&laquo;</span>-->
                <!--            </a>-->
                <!--        </li>-->
                <!--        <?php for ($i = 1; $i <= $totalPages; $i++) { ?>-->
                <!--            <li class="page-item <?php if ($i == $page) echo 'active'; ?>">-->
                <!--                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>-->
                <!--            </li>-->
                <!--        <?php } ?>-->
                <!--        <li class="page-item <?php if ($page == $totalPages) echo 'disabled'; ?>">-->
                <!--            <a class="page-link" href="?page=<?php echo $page + 1; ?>" aria-label="Next">-->
                <!--                <span aria-hidden="true">&raquo;</span>-->
                <!--            </a>-->
                <!--        </li>-->
                <!--    </ul>-->
                <!--</div>-->
                        </div>
                    </div>
                    
                </div>


            </div>
        </div>
    </div>

    <!-- Video Modal -->
    <div id="videoModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Video Preview</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <video id="modalVideo" width="100%" controls>
                        <source src="" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
            </div>
        </div>
    </div>

    <?php include('partials/footer.php'); ?>

    <style>
        /* Hide additional images on mobile devices */
        @media (max-width: 767px) {
            .hidden-mobile {
                display: none;
            }
        }

        /* Show all images on larger screens */
        @media (min-width: 768px) {
            .hidden-mobile {
                display: inline-block;
            }
        }
    </style>

    <script>
        function openVideoModal(videoSrc) {
            var modalVideo = document.getElementById("modalVideo");
            modalVideo.src = videoSrc;
            var videoModal = new bootstrap.Modal(document.getElementById("videoModal"));
            videoModal.show();
        }
    </script>
</body>
</html>
